/**
 * You can make a subclass of Player to employ your own 
 * strategy.  Your subclass can have its own counters
 * and randomness to know when to "press your luck"
 * or when to "quit while you're ahead"
 * 
 * @author Chris Thiel, OFMCap
 * @version 8 Jan 2013
 *
 */
public class Player {

    private String name;
    /**
     * scores[] holds the scores for the 5 rounds
     */
    private int[] scores; 
    /**
     * rollCount keeps track of how many rolls in the current round
     */
    private int rollCount;
    /**
     * times zapped keeps track of how rounds they scored zero
     */
    private int timesZapped;
    /**
     * when go is true, player pressing luck on current round
     */
    private boolean go; 
    public Player(String name) 
    {
        //initialize variables that store info across rounds
        this.name = name;
        this.timesZapped =0;
        //initialize variable that are reset each game
        initNewGame();

    }
    public void initNewRound() {
        go=true;
    }
    public void initNewGame() {
        timesZapped = 0;
        scores = new int[5];
        for (int round=0; round<5; round++)
        {
              scores[round]=0;
        }
        initNewRound();        
    }
    /**
     * the decide method is where to program your strategy
     * by either making setActive(true)--or do nothing-- to press your luck
     * or setting setActive(false) to quit, to bank the pointsSoFar.
     *  
     * @param roundNumber
     * @param pointsSoFar
     */
    public void decide(int roundNumber, int pointsSoFar)
    {
        if (Math.random()<.16)
            this.setActive(false);
        if (pointsSoFar>25)
            this.setActive(false);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public int getTotalScore()
    {
            int total=0;
            for (int s:scores)
                total+=s;
            return total;
    }
    public int getTimesZapped()
    {
            return this.timesZapped;
    }
    public void setScore( int round, int value)
    {
            scores[round-1]=value;
            if(value==0)
                this.timesZapped++;
    }
    public boolean isActive() {
        return go;
    }
    public void setActive(boolean value) {
        this.go=value;
    }
}